// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPApiLog.store.Log', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPApiLog.model.Log',
    autoLoad: false,
    pageSize: 30,
    remoteFilter: true,
    remoteSort: true,
    sorters: [{
        property: 'date',
        direction: 'DESC',
    }],
    proxy: {
        type: 'ajax',
        api: {
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPApiLog/getLogs'),
        },
        reader: {
            type: 'json',
            root: 'data',
        },
    },

});
