// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// {namespace name=backend/viison_pickware_erp_api_log/main}
Ext.define('Shopware.apps.ViisonPickwareERPApiLog.view.Detail', {

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_api_log/main',

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_api_log-detail',
    width: 800,
    height: '90%',
    maximizable: true,
    minimizable: true,
    layout: {
        type: 'fit',
    },
    border: 0,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('main/title') + ': ' + this.getViisonSnippet('detail/title');
        this.items = [{
            xtype: 'form',
            bodyPadding: 10,
            layout: {
                type: 'vbox',
                box: 'start',
                align: 'stretch',
            },
            items: [{
                xtype: 'fieldset',
                padding: 0,
                margin: '0 0 10 0',
                layout: {
                    type: 'hbox',
                    box: 'start',
                    align: 'stretch',
                },
                defaults: {
                    xtype: 'fieldset',
                    flex: 1,
                },
                items: [{
                    border: 0,
                    margin: '0 5 0 0',
                    defaults: {
                        xtype: 'textfield',
                        anchor: '100%',
                        hideTrigger: true,
                    },
                    items: [{
                        xtype: 'datefield',
                        format: 'Y-m-d H:i:s',
                        name: 'date',
                        fieldLabel: this.getViisonSnippet('field/label/date'),
                    }, {
                        name: 'user',
                        fieldLabel: this.getViisonSnippet('field/label/user'),
                    }, {
                        name: 'userAgent',
                        fieldLabel: this.getViisonSnippet('field/label/useragent'),
                    }, {
                        name: 'ipAddress',
                        fieldLabel: this.getViisonSnippet('field/label/ipaddress'),
                    }],
                }, {
                    border: 0,
                    margin: '0 0 0 5',
                    defaults: {
                        xtype: 'textfield',
                        anchor: '100%',
                    },
                    items: [{
                        name: 'method',
                        fieldLabel: this.getViisonSnippet('field/label/method'),
                    }, {
                        name: 'url',
                        fieldLabel: this.getViisonSnippet('field/label/url'),
                    }, {
                        name: 'responseCode',
                        fieldLabel: this.getViisonSnippet('field/label/responsecode'),
                    }, {
                        name: 'computationTime',
                        fieldLabel: this.getViisonSnippet('field/label/computation_time'),
                    }],
                }],
            }, {
                flex: 4,
                xtype: 'fieldset',
                border: 0,
                padding: 0,
                layout: {
                    type: 'hbox',
                    box: 'start',
                    align: 'stretch',
                },
                defaults: {
                    xtype: 'fieldset',
                    flex: 1,
                },
                items: [{
                    xtype: 'fieldset',
                    border: 0,
                    padding: 0,
                    margin: '0 5 0 0',
                    layout: 'fit',
                    items: [{
                        xtype: 'fieldset',
                        border: 0,
                        padding: 0,
                        margin: 0,
                        defaults: {
                            xtype: 'fieldset',
                        },
                        layout: {
                            type: 'vbox',
                            box: 'start',
                            align: 'stretch',
                        },
                        items: [{
                            title: this.getViisonSnippet('fieldset/title/requestheaders'),
                            flex: 1,
                            layout: 'fit',
                            items: {
                                anchor: '100%',
                                name: 'requestHeaders',
                                xtype: 'textareafield',
                                margin: '0 0 5 0',
                            },
                        }, {
                            title: this.getViisonSnippet('fieldset/title/requestdata'),
                            flex: 1,
                            layout: 'fit',
                            items: {
                                anchor: '100%',
                                name: 'requestData',
                                xtype: 'textareafield',
                                margin: '0 0 5 0',
                            },
                            margin: 0,
                        }],
                    }],
                }, {
                    xtype: 'fieldset',
                    border: 0,
                    padding: 0,
                    margin: '0 0 0 5',
                    layout: 'fit',
                    items: [{
                        xtype: 'fieldset',
                        border: 0,
                        padding: 0,
                        margin: 0,
                        defaults: {
                            xtype: 'fieldset',
                        },
                        layout: {
                            type: 'vbox',
                            box: 'start',
                            align: 'stretch',
                        },
                        items: [{
                            title: this.getViisonSnippet('fieldset/title/responseheaders'),
                            flex: 1,
                            layout: 'fit',
                            items: {
                                anchor: '100%',
                                name: 'responseHeaders',
                                xtype: 'textareafield',
                                margin: '0 0 5 0',
                            },
                        }, {
                            title: this.getViisonSnippet('fieldset/title/responsebody'),
                            flex: 1,
                            layout: 'fit',
                            items: {
                                anchor: '100%',
                                name: 'responseData',
                                xtype: 'textareafield',
                                margin: '0 0 5 0',
                            },
                            margin: 0,
                        }],
                    }],
                }],
            }, {
                flex: 1,
                xtype: 'fieldset',
                title: this.getViisonSnippet('fieldset/title/exceptions'),
                layout: 'fit',
                items: {
                    anchor: '100%',
                    name: 'exception',
                    xtype: 'textareafield',
                    margin: '0 0 5 0',
                },
                margin: 0,
            }, {
                xtype: 'textfield',
                name: 'curlCommand',
                margin: '20 0 00 0',
                selectOnFocus: true,
                anchor: '100%',
            }],
        }];

        this.callParent(arguments);

        this.form = this.down('form').getForm();
        this.form.loadRecord(this.record);
    },

});
