// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPApiLog.view.List', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_api_log-list',
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
    },
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_api_log/main',
    viisonConfigNamespace: 'ViisonPickwareERPApiLog',

    /**
     * @Override
     */
    initComponent: function () {
        this.viewConfig = {
            getRowClass: function (record) {
                if (!record.get('responseCode') || record.get('responseCode') >= 400) {
                    return 'x-grid-row-viison-warning';
                }

                return '';
            },
        };
        this.columns = this.getColumns();
        this.dockedItems = this.getDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    getColumns: function () {
        return [{
            xtype: 'datecolumn',
            dataIndex: 'date',
            header: this.getViisonSnippet('column/date/header'),
            format: 'Y-m-d H:i:s',
            width: 120,
        }, {
            dataIndex: 'user',
            header: this.getViisonSnippet('column/user/header'),
            width: 130,
        }, {
            dataIndex: 'method',
            header: this.getViisonSnippet('column/method/header'),
            width: 60,
        }, {
            dataIndex: 'url',
            header: this.getViisonSnippet('column/url/header'),
            flex: 3,
        }, {
            dataIndex: 'responseCode',
            header: this.getViisonSnippet('column/code/header'),
            width: 40,
        }, {
            dataIndex: 'userAgent',
            header: this.getViisonSnippet('column/userAgent/header'),
            flex: 1,
        }, {
            xtype: 'actioncolumn',
            width: 30,
            sortable: false,
            items: [{
                iconCls: 'sprite-magnifier',
                action: 'show',
                tooltip: this.getViisonSnippet('tooltip/showdetail'),
                scope: this,
                handler: function (view, rowIndex) {
                    this.fireEvent('showDetail', this, view.getStore().getAt(rowIndex));
                },
            }],
        }];
    },

    /**
     * @return Ext.toolbar.Toolbar[]
     */
    getDockedItems: function () {
        this.logSizeField = Ext.create('Ext.Component', {
            padding: '0 10 0 10',
            data: {
                logSize: this.getViisonConfig('apiLogSize'),
            },
            tpl: this.getViisonSnippet('log_size/title') + ': {literal}{logSize}{/literal} MB',
        });

        return [{
            xtype: 'toolbar',
            dock: 'top',
            ui: 'shopware-ui',
            items: [
                this.logSizeField,
                {
                    text: this.getViisonSnippet('log_size/button/clean_up/title'),
                    cls: 'secondary small',
                    action: 'truncateLog',
                    scope: this,
                    handler: function () {
                        this.fireEvent('truncateLog', this);
                    },
                },
                '->',
                {
                    xtype: 'textfield',
                    name: 'searchfield',
                    cls: 'searchfield',
                    width: 170,
                    enableKeyEvents: true,
                    emptyText: this.getViisonSnippet('search/initialText'),
                    listeners: {
                        buffer: 500,
                        scope: this,
                        change: function (field) {
                            this.fireEvent('searchFieldChanged', this, field.value);
                        },
                    },
                },
            ],
        }, {
            xtype: 'viison_common_pagination_toolbar-toolbar',
            store: this.store,
        }];
    },

});
