// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

// {namespace name=backend/viison_pickware_erp_api_log/main}
Ext.define('Shopware.apps.ViisonPickwareERPApiLog.view.Main', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_api_log-main',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_api_log/main',

    width: '95%',
    height: '90%',
    maximizable: true,
    minimizable: true,
    layout: {
        type: 'fit',
    },
    border: 0,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('main/title');
        this.items = [{
            xtype: 'viison_pickware_erp_api_log-list',
            store: this.store,
        }];

        this.callParent(arguments);
    },

});
