// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleBarcodeLabelPrinting.controler.Detail', {

    override: 'Shopware.apps.Article.controller.Detail',

    /**
     * @Override
     */
    onSaveArticle: function (win, article, options) {
        // Replace the options' callback to be able to enable the 'print barcode' button
        var existingCallback = (Ext.isObject(options) && Ext.isFunction(options.callback)) ? options.callback : null;
        var mainWindow = win || this.getMainWindow();
        options.callback = function (callbackArticle, success) {
            if (callbackArticle && success) {
                var articleDetail = callbackArticle.getMainDetail().first();
                // Save the article detail in the base field set for easy access
                var baseFieldSet = mainWindow.down('article-base-field-set');
                baseFieldSet.viisonArticleDetail = articleDetail;

                // Update the article number print button
                var printArticleNumberButton = baseFieldSet.down('viison_pickware_erp_article_barcode_label_printing-print_article_barcode_button');
                printArticleNumberButton.setDisabled(articleDetail.phantom || !articleDetail.get('number') || articleDetail.get('number').length === 0);
            }

            // Call the original callback if present
            if (existingCallback) {
                existingCallback(callbackArticle, success);
            }
        };

        this.callParent([win, article, options]);
    },

});
