// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleBarcodeLabelPrinting.view.detail.Base', {

    override: 'Shopware.apps.Article.view.detail.Base',
    /**
     * @var Shopware.apps.Article.model.Detail
     */
    viisonArticleDetail: null,

    /**
     * Finds the article number field in the created elements and wraps it in a container,
     * together with a button for adding the article to the barcode label printing list.
     */
    createLeftElements: function () {
        var items = this.callParent(arguments);

        // Try to find number field
        var numberField;
        var pos = -1;
        Ext.Array.each(items, function (item, index) {
            if (item.name === 'mainDetail[number]') {
                numberField = item;
                pos = index;
            }
        });
        if (pos === -1) {
            return items;
        }

        // Remove label from field
        var label = numberField.getFieldLabel();
        Ext.apply(numberField, {
            fieldLabel: '',
            flex: 1,
        });

        // Create the print button
        var printButton = Ext.create('Shopware.apps.ViisonPickwareERPArticleBarcodeLabelPrinting.view.PrintArticleBarcodeButton', {
            disabled: true,
            getArticleDetail: function () {
                return this.viisonArticleDetail;
            }.bind(this),
        });

        // Wrap the textfield and the print button in a container
        items[pos] = Ext.create('Ext.form.FieldContainer', {
            fieldLabel: label,
            labelWidth: 155,
            layout: 'hbox',
            items: [
                numberField,
                printButton,
            ],
        });

        // Disable print button, if no real article detail is present or the article number is empty
        numberField.on('change', function (field) {
            printButton.setDisabled(!this.viisonArticleDetail || this.viisonArticleDetail.phantom || !field.getValue() || field.getValue().length === 0);
        }, this);

        return items;
    },

});
