// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleBarcodeLabelPrinting.view.detail.Window', {

    override: 'Shopware.apps.Article.view.detail.Window',

    /**
     * @Override
     */
    onStoresLoaded: function () {
        this.callParent(arguments);

        // Save the article detail in the base field set for easy access
        var articleDetail = this.article.getMainDetail().first();
        var baseFieldSet = this.down('article-base-field-set');
        baseFieldSet.viisonArticleDetail = articleDetail;

        // Update the barcode label printing button
        var printArticleNumberButton = baseFieldSet.down('viison_pickware_erp_article_barcode_label_printing-print_article_barcode_button');
        printArticleNumberButton.setDisabled(articleDetail.phantom || !articleDetail.get('number') || articleDetail.get('number').length === 0);
    },

});
