// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleBarcodeLabelPrinting.view.PrintArticleBarcodeButton', {

    extend: 'Ext.button.Button',
    alias: 'widget.viison_pickware_erp_article_barcode_label_printing-print_article_barcode_button',
    cls: Ext.baseCSSPrefix + 'viison_pickware_erp_article_barcode_label_printing-print_article_barcode_button',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_article_barcode_label_printing/main',
    iconCls: 'sprite-barcode',

    style: {
        margin: '5px 0px 0px 5px',
        padding: 0,
        border: 0,
        background: 'none',
    },

    init: function () {
        this.tooltip = this.getViisonSnippet('print_article_barcode_button/tooltip');

        this.callParent(arguments);
    },

    /**
     * Make sure to override this method to return the correct article detail for which
     * a barcode label shall be created when clickin the button.
     *
     * @return Shopware.apps.Article.model.Detail|null
     */
    getArticleDetail: function () {
        return null;
    },

    /**
     * Sends a POST request to the barcode label printing controller to add an article barcode label
     * for the article detail returned by 'getArticleDetail()' to the list. Please note that 'this'
     * refers to the scope of the button, while properties and methods of this button can accessed
     * through 'button'.
     */
    handler: function () {
        // Check the article detail
        var articleDetail = this.getArticleDetail();
        if (!articleDetail || articleDetail.phantom || !articleDetail.get('number')) {
            // Cannot add barcode label without article detail
            return;
        }

        // Send request
        Ext.Ajax.request({
            method: 'POST',
            url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPBarcodeLabelPrinting/enqueueBarcodeLabel'),
            jsonData: {
                type: 'article',
                identifiers: [
                    articleDetail.get('number'),
                ],
            },
            scope: this,
            callback: function (options, success) {
                var title;
                var message;

                if (success) {
                    title = this.getViisonSnippet('print_article_barcode_button/notification/success/title');
                    message = this.getViisonSnippet('print_article_barcode_button/notification/success/message');
                } else {
                    title = this.getViisonSnippet('print_article_barcode_button/notification/failure/title');
                    message = this.getViisonSnippet('print_article_barcode_button/notification/failure/message');
                }

                Shopware.Notification.createGrowlMessage(title, message, 'Pickware');
            },
        });
    },

});
