// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleBarcodeLabelPrinting.view.WarehouseFieldSet.PrintBinLocationBarcodeAction', {

    extend: 'Ext.grid.column.Action',
    alias: 'widget.viison_pickware_erp_article_barcode_label_printing-warehouse_field_set-print_bin_location_barcode_action',
    cls: Ext.baseCSSPrefix + 'viison_pickware_erp_article_barcode_label_printing-warehouse_field_set-print_bin_location_barcode_action',
    iconCls: 'sprite-barcode',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_article_barcode_label_printing/main',

    init: function () {
        this.tooltip = this.getViisonSnippet('print_bin_location_barcode_action/tooltip');

        this.callParent(arguments);
    },

    /**
     * @Override
     */
    getClass: function (value, meta, record) {
        return (!record.get('binLocationId') || record.get('binLocationCode') === 'pickware_default_location') ? 'x-hide-display' : '';
    },

    /**
     * Sends a POST request to the barcode label printing controller to add a bin location barcode
     * label for the bin location of the clicked grid action to the list.
     */
    handler: function (view, rowIndex, colIndex, item, e, record) {
        // Check the bin location
        if (!record.get('binLocationId')) {
            // Cannot add barcode label without bin location
            return;
        }

        // Send request
        Ext.Ajax.request({
            method: 'POST',
            url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPBarcodeLabelPrinting/enqueueBarcodeLabel'),
            jsonData: {
                type: 'bin_location',
                identifiers: [
                    record.get('binLocationId'),
                ],
            },
            scope: this,
            callback: function (options, success) {
                var title;
                var message;

                if (success) {
                    title = this.getViisonSnippet('print_bin_location_barcode_action/notification/success/title');
                    message = this.getViisonSnippet('print_bin_location_barcode_action/notification/success/message');
                } else {
                    title = this.getViisonSnippet('print_bin_location_barcode_action/notification/failure/title');
                    message = this.getViisonSnippet('print_bin_location_barcode_action/notification/failure/message');
                }

                Shopware.Notification.createGrowlMessage(title, message, 'Pickware');
            },
        });
    },

});
