// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleBinLocationList.model.BinLocationMapping', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'articleDetailId', type: 'int' },
        { name: 'articleNumber', type: 'string', mapping: 'articleDetail.number' },
        { name: 'binLocationId', type: 'int' },
        { name: 'binLocation', type: 'auto' },
        { name: 'warehouse', type: 'auto', mapping: 'binLocation.warehouse' },
        { name: 'warehouseId', type: 'auto', mapping: 'binLocation.warehouseId' },
        { name: 'articleDetailConfigurations', type: 'auto', mapping: 'binLocation.warehouse.articleDetailConfigurations' },
        { name: 'stock', type: 'int', defaultValue: 0 },
        { name: 'defaultMapping', type: 'boolean', defaultValue: false },
        {
            name: 'isMappingToNullBinLocation',
            type: 'boolean',
            defaultValue: false,
            convert: function (value, record) {
                return record.get('binLocationId') === record.get('warehouse').nullBinLocationId;
            },
        },
    ],

});
