// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleBinLocationList.store.BinLocationMappings', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPArticleBinLocationList.model.BinLocationMapping',
    groupField: 'warehouseId',

    autoLoad: false,
    remoteFilter: true,
    remoteSort: true,
    remoteGroup: true,

    sorters: [
        { property: 'warehouse.defaultWarehouse', direction: 'DESC' },
        { property: 'warehouse.name', direction: 'ASC' },
        { property: 'warehouse.code', direction: 'ASC' },
        { property: 'isNullBinLocation', direction: 'ASC' },
        { property: 'binLocationMapping.defaultMapping', direction: 'DESC' },
        { property: 'binLocation.code', direction: 'ASC' },
    ],

    proxy: {
        type: 'ajax',
        batchActions: true,
        api: {
            read: ViisonCommonApp.assembleBackendUrl(
                'ViisonPickwareERPArticleBinLocationList/getBinLocationMappings'
            ),
            update: ViisonCommonApp.assembleBackendUrl(
                'ViisonPickwareERPArticleBinLocationList/updateBinLocationMappings'
            ),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
        writer: {
            type: 'json',
            root: 'data',
            allowSingle: false,
        },
    },

});
