// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleEAN.view.detail.Settings', {

    override: 'Shopware.apps.Article.view.detail.Settings',

    /**
     * Changes the label of the EAN field and adds a helper text as well as a new input mask
     * (allowing anything but whitespace) to it.
     */
    createRightElements: function () {
        var elements = this.callParent(arguments);
        Ext.Array.each(elements, function (element) {
            if (element.name === 'mainDetail[ean]') {
                Ext.apply(element, {
                    fieldLabel: ViisonCommonApp.getSnippet(
                        'field/label',
                        'backend/viison_pickware_erp_article_ean/main'
                    ),
                    helpText: ViisonCommonApp.getSnippet(
                        'field/help_text',
                        'backend/viison_pickware_erp_article_ean/main'
                    ),
                    maskRe: new RegExp('[^\\s]'),
                });

                return false;
            }

            return undefined;
        });

        return elements;
    },

});
