// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleEAN.view.variant.Detail', {

    override: 'Shopware.apps.Article.view.variant.Detail',

    /**
     * Changes the label of the EAN field and adds a helper text as well as a new input mask
     * (allowing anything but whitespace) to it.
     */
    createRightSettingsContainer: function () {
        var container = this.callParent(arguments);
        Ext.Array.each(container.items.items, function (item) {
            if (item.name === 'ean') {
                Ext.apply(item, {
                    fieldLabel: ViisonCommonApp.getSnippet(
                        'field/label',
                        'backend/viison_pickware_erp_article_ean/main'
                    ),
                    helpText: ViisonCommonApp.getSnippet(
                        'field/help_text',
                        'backend/viison_pickware_erp_article_ean/main'
                    ),
                    maskRe: new RegExp('[^\\s]'),
                });

                return false;
            }

            return undefined;
        });

        return container;
    },

});
