// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleListBarcodeLabelPrinting.view.table.Category', {

    override: 'Shopware.apps.ArticleList.view.main.Grid',

    /**
     * Creates the grid columns
     *
     * @return [array] grid columns
     */
    getToolbar: function () {
        var toolbar = this.callParent(arguments);

        // Only extend the article list starting from Shopware 5 (the grid xtype was 'articleList-main-grid' in Shopware 4)
        if (this.getXType() === 'multi-edit-main-grid') {
            this.addArticleLabelButton = Ext.create('Ext.button.Button', {
                iconCls: 'sprite-barcode',
                text: ViisonCommonApp.getSnippet('button/add_article_label/all_articles_text', 'backend/viison_pickware_erp_article_list_barcode_label_printing/main'),
                action: 'viisonPickwareERPAddArticleLabel',
                scope: this,
                handler: function (button) {
                    var selectionModel = this.getSelectionModel();
                    var records = selectionModel.getSelection();
                    this.fireEvent('viisonPickwareERPAddArticleLabel', records, this, button);
                },
            });

            // Insert 'Add article labels' button
            toolbar.insert(3, this.addArticleLabelButton);
        }

        return toolbar;
    },

    /**
     * @Override
     *
     * Adjust the text of the barcode label printing button dependant on the current selection.
     */
    getGridSelModel: function () {
        var model = this.callParent(arguments);

        // Do nothing in Shopware 4 where label printing is not supported from the article list
        if (!this.addArticleLabelButton) {
            return model;
        }

        model.addListener('selectionchange', function (selectionModel, selections) {
            if (selections.length > 0) {
                this.addArticleLabelButton.setText(ViisonCommonApp.getSnippet('button/add_article_label/selected_articles_text', 'backend/viison_pickware_erp_article_list_barcode_label_printing/main'));
            } else {
                this.addArticleLabelButton.setText(ViisonCommonApp.getSnippet('button/add_article_label/all_articles_text', 'backend/viison_pickware_erp_article_list_barcode_label_printing/main'));
            }
        }, this);

        return model;
    },

});
