// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleListStockColumn.view.main.Grid', {

    override: 'Shopware.apps.ArticleList.view.main.Grid',

    /*
     * @Override
     */
    getColumns: function () {
        var columns = this.callParent(arguments);

        // Change header and tooltip of the 'Detail_inStock' column and disable the row editors
        // of the columns 'Detail_inStock', 'Attribute_pickwareIncomingStock' and
        // 'Attribute_pickwarePhysicalStockForSale'
        Ext.each(columns, function (column) {
            if (column.dataIndex === 'Detail_inStock') {
                column.header = ViisonCommonApp.getSnippet(
                    'column/in_stock/header',
                    'backend/viison_pickware_erp_article_list_stock_column/main'
                );
                column.tooltip = ViisonCommonApp.getSnippet(
                    'column/in_stock/tooltip',
                    'backend/viison_pickware_erp_article_list_stock_column/main'
                );
                column.editor = null;
            } else if (column.dataIndex === 'Attribute_pickwareIncomingStock' || column.dataIndex === 'Attribute_pickwarePhysicalStockForSale') {
                column.editor = null;
            }
        });

        return columns;
    },

});
