// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

ViisonCommonApp.registerExtraModelFields(
    'Shopware.apps.Article.model.Detail',
    [
        { name: 'pickwarePhysicalStockForSale', type: 'int' },
        { name: 'pickwareStockManagementDisabled', type: 'boolean' },
        {
            name: 'pickwareReservedStock',
            convert: function (value, record) {
                return (record.get('pickwareStockManagementDisabled')) ? null : (record.get('pickwarePhysicalStockForSale') - record.get('inStock'));
            },
        },
    ]
);
