// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleOrders.store.ArticleOrder', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPArticleOrders.model.ArticleOrder',
    autoLoad: false,
    remoteFilter: true,
    remoteSort: true,
    sorters: [{
        direction: 'DESC',
        property: 'date',
    }],
    proxy: {
        type: 'ajax',
        api: {
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPArticleOrders/getArticleOrdersList'),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

});
