// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleOrders.view.detail.ArticleOrdersList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_article_orders-detail-article_orders_list',
    cls: 'viison-common--grid has--vertical-lines has--no-borders',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_article_orders/main',

    style: 'border-bottom:1px solid #a4b5c0 !important;',
    border: true,
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.emptyText = this.getViisonSnippet('list/empty_text');
        this.columns = this.createColumns();
        this.dockedItems = [
            Ext.create('Ext.toolbar.Toolbar', {
                dock: 'top',
                ui: 'shopware-ui is--viison-common--toolbar',
                padding: 12,
                border: false,
                items: this.getTopToolbarItems(),
            }),
            {
                xtype: 'viison_common_pagination_toolbar-toolbar',
                store: this.store,
            },
        ];

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createColumns: function () {
        return [{
            dataIndex: 'orderNumber',
            header: this.getViisonSnippet('model/article_order/order_number'),
            flex: 1,
        }, {
            xtype: 'datecolumn',
            dataIndex: 'date',
            header: this.getViisonSnippet('model/article_order/date'),
            flex: 1,
        }, {
            dataIndex: 'orderStatus',
            header: this.getViisonSnippet('model/article_order/order_status'),
            flex: 1,
            renderer: ViisonStatusTranslator.translateOrderStatus,
        }, {
            dataIndex: 'paymentStatus',
            header: this.getViisonSnippet('model/article_order/payment_status'),
            flex: 1,
            renderer: ViisonStatusTranslator.translatePaymentStatus,
        }, {
            dataIndex: 'articleNumber',
            header: this.getViisonSnippet('model/article_order/article_number'),
            flex: 1,
        }, {
            dataIndex: 'articleName',
            header: this.getViisonSnippet('model/article_order/article_name'),
            flex: 1,
        }, {
            dataIndex: 'quantity',
            align: 'right',
            header: this.getViisonSnippet('model/article_order/quantity'),
            flex: 1,
        }, {
            xtype: 'numbercolumn',
            dataIndex: 'price',
            align: 'right',
            header: this.getViisonSnippet('model/article_order/price'),
            flex: 1,
        }, {
            dataIndex: 'dispatchMethod',
            header: this.getViisonSnippet('model/article_order/dispatch_method'),
            flex: 1,
        }, {
            dataIndex: 'paymentMethod',
            header: this.getViisonSnippet('model/article_order/payment_method'),
            flex: 1,
        }, {
            dataIndex: 'customerNumber',
            header: this.getViisonSnippet('model/article_order/customer_number'),
            flex: 1,
        }, {
            dataIndex: 'billingCompany',
            header: this.getViisonSnippet('model/article_order/billing_company'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'billingDepartment',
            header: this.getViisonSnippet('model/article_order/billing_company'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'billingSalutation',
            header: this.getViisonSnippet('model/article_order/billing_salutation'),
            flex: 1,
            hidden: true,
            renderer: this.salutationRenderer,
        }, {
            dataIndex: 'billingFirstName',
            header: this.getViisonSnippet('model/article_order/billing_first_name'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'billingLastName',
            header: this.getViisonSnippet('model/article_order/billing_last_name'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'billingStreet',
            header: this.getViisonSnippet('model/article_order/billing_street'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'billingZipCode',
            header: this.getViisonSnippet('model/article_order/billing_zip_code'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'billingCity',
            header: this.getViisonSnippet('model/article_order/billing_city'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'billingCountry',
            header: this.getViisonSnippet('model/article_order/billing_country'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'shippingCompany',
            header: this.getViisonSnippet('model/article_order/shipping_company'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'shippingDepartment',
            header: this.getViisonSnippet('model/article_order/shipping_department'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'shippingSalutation',
            header: this.getViisonSnippet('model/article_order/shipping_salutation'),
            flex: 1,
            hidden: true,
            renderer: this.salutationRenderer,
        }, {
            dataIndex: 'shippingFirstName',
            header: this.getViisonSnippet('model/article_order/shipping_first_name'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'shippingLastName',
            header: this.getViisonSnippet('model/article_order/shipping_last_name'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'shippingStreet',
            header: this.getViisonSnippet('model/article_order/shipping_street'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'shippingZipCode',
            header: this.getViisonSnippet('model/article_order/shipping_zip_code'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'shippingCity',
            header: this.getViisonSnippet('model/article_order/shipping_city'),
            flex: 1,
            hidden: true,
        }, {
            dataIndex: 'shippingCountry',
            header: this.getViisonSnippet('model/article_order/shipping_country'),
            flex: 1,
            hidden: true,
        }, {
            xtype: 'actioncolumn',
            align: 'center',
            width: 60,
            items: [{
                iconCls: 'sprite-user',
                tooltip: this.getViisonSnippet('action_column/show_customer/tooltip'),
                scope: this,
                handler: function (view, rowIndex) {
                    this.fireEvent('showCustomer', view.getStore().getAt(rowIndex));
                },
            }, {
                iconCls: 'sprite-inbox',
                tooltip: this.getViisonSnippet('action_column/show_order/tooltip'),
                scope: this,
                handler: function (view, rowIndex) {
                    this.fireEvent('showOrder', view.getStore().getAt(rowIndex));
                },
            }],
        }];
    },

    /**
     * @return Ext.Component[]
     */
    getTopToolbarItems: function () {
        return [{
            xtype: 'label',
            cls: 'is--viison-common--label',
            text: ViisonCommonApp.getSnippet(
                'field_label',
                'backend/viison_common_variant_combo_box/main'
            ) + ':',
            margin: '0 10 6 0',
        }, {
            xtype: 'viison_common_variant_combo_box-combo_box',
            name: 'variantSelection',
            allowBlank: true,
            width: 200,
            hideLabel: true,
        }, {
            xtype: 'tbspacer',
            width: 25,
        }, {
            xtype: 'label',
            cls: 'is--viison-common--label',
            text: this.getViisonSnippet('toolbar/filter/from/label') + ':',
            margin: '0 10 6 0',
        }, {
            xtype: 'datefield',
            name: 'from',
            hideLabel: true,
            width: 110,
            maxValue: new Date(),
            action: 'filter',
        }, {
            xtype: 'tbspacer',
            width: 25,
        }, {
            xtype: 'label',
            cls: 'is--viison-common--label',
            text: this.getViisonSnippet('toolbar/filter/to/label') + ':',
            margin: '0 10 6 0',
        }, {
            xtype: 'datefield',
            name: 'to',
            hideLabel: true,
            width: 110,
            maxValue: new Date(),
            action: 'filter',
        }, '->', {
            cls: 'primary small',
            action: 'export',
            text: this.getViisonSnippet('toolbar/button/export/text'),
        }];
    },

    /**
     * @param String value
     * @return String
     */
    salutationRenderer: function (value) {
        if (value === 'ms') {
            return this.getViisonSnippet('salutation/ms');
        }
        if (value === 'mr') {
            return this.getViisonSnippet('salutation/mr');
        }

        return value;
    },

});
