// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleOrders.view.detail.Window', {

    override: 'Shopware.apps.Article.view.detail.Window',

    /**
     * @Override
     */
    createMainTabPanel: function () {
        var tabPanel = this.callParent(arguments);

        // Register article orders tab panel
        this.registerAdditionalTab({
            title: ViisonCommonApp.getSnippet('tab/title', 'backend/viison_pickware_erp_article_orders/main'),
            insertIndex: 9,
            tabConfig: {
                name: 'viison_pickware_erp_article_orders-tab',
            },
            contentFn: this.createViisonPickwareERPArticleOrdersTab,
            articleChangeFn: function (article) {
                this.subApplication.getController('Shopware.apps.ViisonPickwareERPArticleOrders.controller.Main').setArticle(article);
            },
            scope: this,
        });

        return tabPanel;
    },

    /**
     * @param article
     * @param stores
     * @param eOpts
     */
    createViisonPickwareERPArticleOrdersTab: function (article, stores, eOpts) {
        // Create main controller
        this.subApplication.addController({
            name: 'Shopware.apps.ViisonPickwareERPArticleOrders.controller.Main',
        });
        var controller = this.subApplication.getController('Shopware.apps.ViisonPickwareERPArticleOrders.controller.Main');
        controller.setArticle(this.article);

        // Create the article orders tab
        this.viisonPickwareERPArticleOrdersTab = controller.createArticleOrdersTab();

        // Add tab content and enable it, if the loaded article already exists
        eOpts.tab.add(this.viisonPickwareERPArticleOrdersTab);
        eOpts.tab.setDisabled(this.article.get('id') === null);
    },

});
