// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleProfitMargin.view.detail.Base', {

    override: 'Shopware.apps.Article.view.detail.Base',

    /**
     * Find and modify purchasePrice numberfield, add event on change
     *
     * @returns elements
     */
    createRightElements: function () {
        var elements = this.callParent(arguments);

        Ext.Array.each(elements, function (element) {
            if (element.name === 'taxId') {
                element.on('change', function (field, newValue) {
                    var taxIndex = field.store.findExact(field.valueField, newValue);
                    var tax = (taxIndex > -1) ? field.store.getAt(taxIndex) : null;
                    this.subApp.articleWindow.fireEvent('articleTaxChanged', field, tax);
                }, this);
            } else if (element.name === 'mainDetail[purchasePrice]') {
                // Add listener if puchasePrice changes, fire event to notify price grid
                var listeners = element.listeners || {};
                listeners.change = function (field, newValue) {
                    this.subApp.articleWindow.fireEvent('viisonPurchasePriceChanged', field, newValue);
                }.bind(this);
                element.listeners = listeners;
            }
        }, this);

        return elements;
    },

});
