// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleProfitMargin.view.variant.Detail', {

    override: 'Shopware.apps.Article.view.variant.Detail',

    /**
     * Find and modify purchasePrice numberfield, add event on change
     *
     * @returns elements
     */
    createBaseFieldSet: function () {
        var elements = this.callParent(arguments);

        Ext.Array.each(elements.items.items, function (element) {
            if (element.name === 'purchasePrice') {
                // Add listener if puchasePrice changes, fire event to notify price grid
                element.on({
                    scope: this,
                    change: function (field, newValue) {
                        this.subApp.articleWindow.fireEvent('viisonPurchasePriceChanged', field, newValue);
                    },
                });
            }
        }, this);

        return elements;
    },

    /**
     * @Override
     */
    createPriceFieldSet: function () {
        // Add a subscriber on the 'didCreateElements' event to be able to set the correct
        // 'mainArticle', which is an article, not an article detail, and tax store
        var onDidCreateElements = function (priceFieldSet) {
            priceFieldSet.mainArticle = this.subApp.articleWindow.article;
            priceFieldSet.taxStore = this.subApp.articleWindow.taxStore;
        };
        this.subApp.articleWindow.on('didCreateElements', onDidCreateElements, this);
        this.on('beforedestroy', function () {
            this.subApp.articleWindow.un('didCreateElements', onDidCreateElements, this);
        }, this);

        return this.callParent(arguments);
    },

});
