// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticlePurchasePrice.view.detail.Base', {

    override: 'Shopware.apps.Article.view.detail.Base',

    /**
     * Changes the label of the purchase price field.
     */
    createRightElements: function () {
        var elements = this.callParent(arguments);
        Ext.Array.each(elements, function (element) {
            if (element.name === 'mainDetail[purchasePrice]') {
                var lastPurchaseSnippet = ViisonCommonApp.getSnippet(
                    'last_purchase_price',
                    'backend/viison_pickware_erp_article_purchase_price/main'
                );
                var lastPurchaseHint = ViisonCommonApp.getSnippet(
                    'last_purchase_price_hint',
                    'backend/viison_pickware_erp_article_purchase_price/main'
                );
                Ext.apply(element, {
                    fieldLabel: ViisonPickwarePurchasePriceHelper.purchasePriceLabel(lastPurchaseSnippet),
                    helpText: lastPurchaseHint,
                });

                return false;
            }

            return undefined;
        });

        return elements;
    },

});
