// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticlePurchasePrice.view.variant.Detail', {

    override: 'Shopware.apps.Article.view.variant.Detail',

    /**
     * Changes the label of the purchase price field.
     */
    createBaseFieldSet: function () {
        var container = this.callParent(arguments);
        Ext.Array.each(container.items.items, function (item) {
            if (item.name === 'purchasePrice') {
                var lastPurchaseSnippet = ViisonCommonApp.getSnippet(
                    'last_purchase_price',
                    'backend/viison_pickware_erp_article_purchase_price/main'
                );
                Ext.apply(item, {
                    fieldLabel: ViisonPickwarePurchasePriceHelper.purchasePriceLabel(lastPurchaseSnippet),
                });

                return false;
            }

            return undefined;
        });

        return container;
    },

});
