// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * Hook the save action on the article detail controller so we can patch the value of pickware_stock_management_disabled
 * into the article's main detail so we can update the disabled state of the stock tab.
 */
Ext.define('Shopware.apps.ViisonPickwareERPArticleStock.controller.Article.Detail', {

    override: 'Shopware.apps.Article.controller.Detail',

    /**
     * @Override
     */
    onSaveArticle: function (win, article, options) {
        var mainWindow = win || this.getMainWindow();
        var existingCallback = (Ext.isObject(options) && Ext.isFunction(options.callback)) ? options.callback : Ext.emptyFn;
        options.callback = function (savedArticle, success) {
            if (savedArticle && success) {
                mainWindow.setStockTabDisabled(savedArticle.get('id') === null);
            }

            // Call the original callback if present
            existingCallback(savedArticle, success);
        };

        this.callParent([win, article, options]);
    },

});
