// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleStock.model.Stock', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'articleDetailId', type: 'int' },
        { name: 'warehouseId', type: 'int' },
        { name: 'type', type: 'string' },
        { name: 'correction', type: 'bool' },
        { name: 'articleNumber', type: 'string' },
        { name: 'articleName', type: 'string' },
        { name: 'changeAmount', type: 'int', useNull: true },
        { name: 'oldStock', type: 'int' },
        { name: 'newStock', type: 'int' },
        { name: 'purchasePrice', type: 'float', useNull: true },
        { name: 'username', type: 'string' },
        { name: 'created', type: 'date', dateFormat: 'd.m.Y' },
        { name: 'comment', type: 'string', useNull: true },
        { name: 'changedBinLocations', type: 'auto', defaultValue: {} },
        { name: 'orderId', type: 'int', useNull: true },
        { name: 'supplierOrderId', type: 'int', useNull: true },
        { name: 'returnShipmentId', type: 'int', useNull: true },
    ],
    proxy: {
        type: 'ajax',
        api: {
            update: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPArticleStock/updateStock'),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

});
