// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleStock.view.detail.Window', {

    override: 'Shopware.apps.Article.view.detail.Window',

    /**
     * @Override
     */
    createMainTabPanel: function () {
        var tabPanel = this.callParent(arguments);

        // Register stock tab panel
        this.registerAdditionalTab({
            title: ViisonCommonApp.getSnippet('tab/title', 'backend/viison_pickware_erp_article_stock/main'),
            insertIndex: 9,
            tabConfig: {
                name: 'viison_pickware_erp_article_stock-tab',
            },
            contentFn: this.createViisonPickwareERPArticleStockTab,
            articleChangeFn: function (article) {
                var controller = this.subApplication.getController(
                    'Shopware.apps.ViisonPickwareERPArticleStock.controller.Main'
                );
                controller.setArticle(article);
            },
            scope: this,
        });

        return tabPanel;
    },

    /**
     * @param article
     * @param stores
     * @param eOpts
     */
    createViisonPickwareERPArticleStockTab: function (article, stores, eOpts) {
        // Create main controller
        this.subApplication.addController({
            name: 'Shopware.apps.ViisonPickwareERPArticleStock.controller.Main',
        });
        var controller = this.subApplication.getController('Shopware.apps.ViisonPickwareERPArticleStock.controller.Main');
        controller.setArticle(article);

        // Create and add the stock list panel
        this.viisonPickwareERPArticleStockTab = eOpts.tab;
        this.viisonPickwareERPArticleStockTab.add(controller.createArticleStockListTab());
        this.viisonPickwareERPArticleStockTab.setDisabled(article.get('id') === null);
    },

    /**
     * Updates the stock list tab with the given article.
     *
     * Sets the article in the combo box so the stocks grid is reloaded with this article. This update function is
     * necessary when saving a new article. Once the tab is created without an article it needs to be updated as soon as
     * the article is saved and the tab is activated.
     *
     * @param {Shopware.apps.Base.model.Article} article
     */
    ViisonPickwareERPArticleStockUpdateWithArticle: function (article) {
        this.setStockTabDisabled(article.get('id') === null);
        // Pass the article to the variant selection to load its data
        var variantSelection = this.viisonPickwareERPArticleStockTab.down('viison_common_variant_combo_box-combo_box');
        variantSelection.setArticle(article);
    },

    setStockTabDisabled: function (disabled) {
        this.viisonPickwareERPArticleStockTab.setDisabled(disabled);
    },
});
