// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleStockFieldSet.controller.Variant', {

    override: 'Shopware.apps.Article.controller.Variant',

    /**
     * @Override
     */
    onSaveVariant: function (win) {
        // Make sure the available stock editing is cancelled before saving
        win.down('viison_pickware_erp_article_stock_field_set-stock_grid').cancelEditing();

        this.callParent(arguments);
    },

    /**
     * @Override
     *
     * Shopware does not update the variant model instance after saving it. Since the minimum stock value of an
     * article variant is calculated on the server side, we need to updated this property manually based on the
     * return values of the called server action.
     */
    saveVariant: function (variant, win, options) {
        var backupedSaveMethod = variant.save;
        variant.save = function (saveOptions) {
            var backupedSuccessCallback = saveOptions.success;

            saveOptions.success = function (record, operation) {
                var updatedVariantData = JSON.parse(operation.response.responseText).data;

                // Update the stockMin property manually and mark it as not modified
                variant.set('stockMin', updatedVariantData.stockMin);
                delete variant.modified.stockMin;

                // Call the default success callback
                Ext.callback(backupedSuccessCallback, this, arguments);
            };

            Ext.callback(backupedSaveMethod, variant, [saveOptions]);
        };

        this.callParent([variant, win, options]);

        variant.save = backupedSaveMethod;
    },

});
