// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleStockFieldSet.view.detail.Settings', {

    override: 'Shopware.apps.Article.view.detail.Settings',

    /**
     * @Override
     */
    createLeftElements: function () {
        var elements = this.callParent(arguments);

        // Remove the 'inStock' and 'stockMin' fields from the elements
        var inStockField;
        var stockMinField;
        Ext.Array.each(elements, function (element) {
            if (element.name === 'mainDetail[inStock]') {
                inStockField = element;
            } else if (element.name === 'mainDetail[stockMin]') {
                stockMinField = element;
            }
        });
        if (inStockField) {
            Ext.Array.remove(elements, inStockField);
        }
        if (stockMinField) {
            Ext.Array.remove(elements, stockMinField);
        }

        return elements;
    },

    /**
     * @Override
     */
    createRightElements: function () {
        var elements = this.callParent(arguments);

        // Remove the 'onSale' (lastStock) field from the elements
        var onSaleField;
        Ext.Array.each(elements, function (element) {
            if (element.name === 'lastStock') {
                onSaleField = element;

                return false;
            }

            return undefined;
        });
        if (onSaleField) {
            Ext.Array.remove(elements, onSaleField);
        }

        return elements;
    },

});
