// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleStockFieldSet.view.detail.Window', {

    override: 'Shopware.apps.Article.view.detail.Window',

    /**
     * @Override
     */
    onStoresLoaded: function () {
        this.callParent(arguments);

        // Update the stock field set
        var stockFieldSet = this.down('viison_pickware_erp_article_stock_field_set-stock_field_set');
        stockFieldSet.reloadData(this.article.getMainDetail().first());
    },

    /**
     * @Override
     */
    createBaseTab: function () {
        var container = this.callParent(arguments);
        var pos = -1;

        // Find the prices field set
        Ext.Array.each(this.detailForm.items.items, function (item, index) {
            if (Ext.getClassName(item) === 'Shopware.apps.Article.view.detail.Prices') {
                pos = index;

                return false;
            }

            return undefined;
        });

        // Add the stock field set right after the prices panel
        this.detailForm.insert((pos + 1), Ext.create('Shopware.apps.ViisonPickwareERPArticleStockFieldSet.view.StockFieldSet', {
            fieldNames: {
                physicalStock: 'mainDetail[pickwarePhysicalStockForSale]',
                reservedStock: 'mainDetail[pickwareReservedStock]',
                notStockManaged: 'mainDetail[pickwareStockManagementDisabled]',
                availableStock: 'mainDetail[inStock]',
                minimumStock: 'mainDetail[stockMin]',
                onSale: 'lastStock',
            },
        }));

        return container;
    },

});
