// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleStockFieldSet.view.variant.Detail', {

    override: 'Shopware.apps.Article.view.variant.Detail',

    /**
     * Feature-detection flag that is set to true when we detect that variants have a lastStock field (this is the case
     * since Shopware 5.4).
     */
    variantsHaveLastStock: false,

    /**
     * @Override
     */
    initComponent: function () {
        var onAfterRender = function () {
            if (this.record) {
                this.down('viison_pickware_erp_article_stock_field_set-stock_field_set').reloadData(this.record);
            }
        };

        this.on('afterrender', onAfterRender, this);
        this.on('beforedestroy', function () {
            this.subApp.articleWindow.un('afterrender', onAfterRender, this);
        }, this);

        this.callParent(arguments);
    },

    /**
     * @Override
     */
    createFormItems: function () {
        var items = this.callParent(arguments);
        var pos = -1;

        // Find the prices field set
        Ext.Array.each(items, function (item, index) {
            if (Ext.getClassName(item) === 'Shopware.apps.Article.view.detail.Prices') {
                pos = index;

                return false;
            }

            return undefined;
        });

        // Add the stock field set right after the prices panel
        Ext.Array.insert(items, (pos + 1), [
            Ext.create('Shopware.apps.ViisonPickwareERPArticleStockFieldSet.view.StockFieldSet', {
                articleDetail: this.record,
                onSaleCheckboxHidden: !this.variantsHaveLastStock,
            }),
        ]);

        return items;
    },

    /**
     * @Override
     */
    createLeftSettingsContainer: function () {
        var container = this.callParent(arguments);

        // Remove the 'inStock' and 'stockMin' fields from the elements
        var inStockField;
        var stockMinField;
        Ext.Array.each(container.items.items, function (item) {
            if (item.name === 'inStock') {
                inStockField = item;
            } else if (item.name === 'stockMin') {
                stockMinField = item;
            }
        });
        if (inStockField) {
            container.remove(inStockField);
        }
        if (stockMinField) {
            container.remove(stockMinField);
        }

        return container;
    },

    /**
     * @Override
     */
    createRightSettingsContainer: function () {
        var container = this.callParent(arguments);

        // Remove the 'lastStock' field from the elements if it exists, since we move it to the stock field set
        var lastStockField;
        Ext.Array.each(container.items.items, function (item) {
            if (item.name === 'lastStock') {
                lastStockField = item;
            }
        });
        if (lastStockField) {
            container.remove(lastStockField);

            // Set the feature detection flag so we know to actually show the lastStock field as part of the stock field
            // set
            this.variantsHaveLastStock = true;
        }

        return container;
    },

});
