// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleSupplierAssignment.controller.Article.Detail', {

    override: 'Shopware.apps.Article.controller.Detail',

    /**
     * @Override
     */
    onSaveArticle: function (win, article, options) {
        var mainWindow = win || this.getMainWindow();
        var originalCallback = (Ext.isObject(options) && Ext.isFunction(options.callback)) ? options.callback : Ext.emptyFn;
        options.callback = function (savedArticle, success) {
            if (savedArticle && success) {
                mainWindow.down('viison_pickware_erp_article_supplier_assignment-detail-supplier_assignment').setSupplierTabDisabled(savedArticle.get('id') === null);
            }

            originalCallback(savedArticle, success);
        };

        this.callParent(arguments);
    },

});
