// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleSupplierAssignment.controller.Variant', {

    override: 'Shopware.apps.Article.controller.Variant',

    /**
     * @override
     *
     * This function is called after variants have been generated. We need to update the variant selection box of the
     * supplier assignment tab. So we basically reload the the information of this tab (which now contains the new
     * variants).
     */
    onSaveConfiguratorSet: function () {
        this.getMainWindow().down('viison_pickware_erp_article_supplier_assignment-detail-supplier_assignment')
            .updateWithArticle(this.subApplication.article);

        this.callParent(arguments);
    },

});
