// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleSupplierAssignment.model.Supplier', {

    extend: 'Shopware.apps.ViisonPickwareERPSupplierManagement.model.Supplier',
    fields: [
        { name: 'articleDetailId', type: 'int' },
        { name: 'defaultSupplier', type: 'boolean' },
        { name: 'purchasePrice', type: 'float', useNull: true },
        { name: 'packingUnit', type: 'int', defaultValue: 1 },
        { name: 'minimumOrderAmount', type: 'int', useNull: true },
        { name: 'supplierArticleNumber', type: 'string' },
    ],
    associations: [{
        type: 'hasOne',
        model: 'Shopware.apps.Base.model.Currency',
        associationKey: 'currency',
        getterName: 'getCurrency',
        setterName: 'setCurrency',
    }],

});
