// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleSupplierAssignment.view.detail.SupplierAssignment', {

    extend: 'Shopware.apps.ViisonPickwareERPSupplierCommon.view.AssignmentPanel',
    alias: 'widget.viison_pickware_erp_article_supplier_assignment-detail-supplier_assignment',
    leftTitle: ViisonCommonApp.getSnippet(
        'assignment/left_title',
        'backend/viison_pickware_erp_article_supplier_assignment/main'
    ),
    rightTitle: ViisonCommonApp.getSnippet(
        'assignment/right_title',
        'backend/viison_pickware_erp_article_supplier_assignment/main'
    ),
    border: false,
    style: {
        borderBottom: '1px solid #a4b5c0',
    },
    bodyStyle: {
        borderTop: '1px solid #a4b5c0',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.dockedItems = [{
            xtype: 'toolbar',
            dock: 'top',
            ui: 'shopware-ui is--viison-common--toolbar',
            padding: 12,
            border: false,
            items: [
                {
                    xtype: 'label',
                    cls: 'is--viison-common--label',
                    text: ViisonCommonApp.getSnippet(
                        'field_label',
                        'backend/viison_common_variant_combo_box/main'
                    ) + ':',
                    margin: '0 10 6 0',
                }, {
                    xtype: 'viison_common_variant_combo_box-combo_box',
                    name: 'variantSelection',
                    width: 200,
                    hideLabel: true,
                },
                '->',
                {
                    text: this.getViisonSnippet(
                        'assignment/toolbar/copy_assignments_button',
                        'backend/viison_pickware_erp_article_supplier_assignment/main'
                    ),
                    cls: 'primary small',
                    action: 'copyAssignmentToAllVariants',
                    disabled: true,
                    handler: function () {
                        this.fireEvent('copyAssignmentToAllVariants', this);
                    },
                    scope: this,
                },
            ],
        }];

        this.callParent(arguments);
    },

    /**
     * Updates this panel with the given article.
     *
     * @param {Shopware.apps.Base.model.Article} article
     */
    updateWithArticle: function (article) {
        this.setSupplierTabDisabled(article.get('id') === null); // Disables/enables the tab above this panel
        this.down('viison_common_variant_combo_box-combo_box').setArticle(article);
    },

    setSupplierTabDisabled: function (disabled) {
        this.up('container').setDisabled(disabled); // Disables/enables the tab above this panel
    },

    /**
     * @Override
     */
    createLeftColumns: function () {
        return this.createSupplierColumns();
    },

    /**
     * @Override
     */
    getRightPanelConfig: function () {
        var config = this.callParent(arguments);
        // Allow row editing
        config.plugins = config.plugins || [];
        config.plugins.push(Ext.create('Ext.grid.plugin.RowEditing', {
            clicksToMoveEditor: 1,
            autoCancel: false,
            listeners: {
                edit: function (editor, e) {
                    // Explicitly set the purchase price and default flag to fix conversion errors
                    e.record.set('defaultSupplier', e.newValues.defaultSupplier);
                    e.record.set('purchasePrice', e.newValues.purchasePrice);
                    e.record.commit();
                    this.fireEvent('supplierRowEdited', this, e.record);
                },
                scope: this,
            },
        }));

        // Add pagination
        config.dockedItems = config.dockedItems || [];
        config.dockedItems.splice(0, 0, this.createPagingToolbar(this.rightStore));

        return config;
    },

    /**
     * @Override
     */
    createRightColumns: function () {
        var columns = this.createSupplierColumns();
        // Add three more columns for editing the purchase price, order quantity and default supplier status
        columns.push({
            header: this.getViisonSnippet(
                'supplier/field/supplierArticleNumber',
                'backend/viison_pickware_erp_article_supplier_assignment/main'
            ),
            dataIndex: 'supplierArticleNumber',
            flex: 1,
            editor: {
                xtype: 'textfield',
            },
        }, {
            header: ViisonPickwarePurchasePriceHelper.purchasePriceLabel(
                this.getViisonSnippet(
                    'assignment/column/purchase_price',
                    'backend/viison_pickware_erp_article_supplier_assignment/main'
                )
            ),
            dataIndex: 'purchasePrice',
            width: 75,
            align: 'right',
            editor: {
                xtype: 'numberfield',
                allowBlank: true,
                minValue: 0,
                step: 0.01,
            },
            scope: this,
            renderer: ViisonCurrencyFormatter.formatWithCurrencyInRecord,
        }, {
            header: this.getViisonSnippet(
                'assignment/column/packing_unit',
                'backend/viison_pickware_erp_article_supplier_assignment/main'
            ),
            dataIndex: 'packingUnit',
            width: 75,
            align: 'right',
            editor: {
                xtype: 'numberfield',
                allowBlank: false,
                minValue: 1,
                step: 1,
            },
        }, {
            header: this.getViisonSnippet(
                'assignment/column/minimum_order_amount',
                'backend/viison_pickware_erp_article_supplier_assignment/main'
            ),
            dataIndex: 'minimumOrderAmount',
            width: 75,
            align: 'right',
            editor: {
                xtype: 'numberfield',
                allowBlank: true,
                minValue: 0,
                step: 1,
            },
        }, {
            header: this.getViisonSnippet(
                'assignment/column/default_supplier',
                'backend/viison_pickware_erp_article_supplier_assignment/main'
            ),
            dataIndex: 'defaultSupplier',
            width: 75,
            align: 'center',
            editor: {
                xtype: 'checkbox',
            },
            renderer: function (value, meta) {
                var tooltip = ViisonCommonApp.getSnippet(
                    'assignment/column/default_supplier',
                    'backend/viison_pickware_erp_article_supplier_assignment/main'
                );
                meta.tdAttr = 'data-qtip="' + tooltip + '"';

                return (value) ? '<div style="height:14px;" class="viison-common--icon--checkmark"></div>' : '';
            },
        });

        return columns;
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createSupplierColumns: function () {
        return [{
            header: this.getViisonSnippet(
                'supplier/field/name',
                'backend/viison_pickware_erp_article_supplier_assignment/main'
            ),
            dataIndex: 'name',
            flex: 1,
        }, {
            header: this.getViisonSnippet(
                'supplier/field/contact',
                'backend/viison_pickware_erp_article_supplier_assignment/main'
            ),
            dataIndex: 'contact',
            flex: 1,
        }, {
            header: this.getViisonSnippet(
                'supplier/field/email',
                'backend/viison_pickware_erp_article_supplier_assignment/main'
            ),
            dataIndex: 'email',
            flex: 1,
        }, {
            header: this.getViisonSnippet(
                'supplier/field/phone',
                'backend/viison_pickware_erp_article_supplier_assignment/main'
            ),
            dataIndex: 'phone',
            flex: 1,
        }];
    },

});
