// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleSupplierAssignment.view.detail.Window', {

    override: 'Shopware.apps.Article.view.detail.Window',

    /**
     * @Override
     */
    createMainTabPanel: function () {
        var tabPanel = this.callParent(arguments);

        // Register supplier assignment tab panel
        this.registerAdditionalTab({
            title: ViisonCommonApp.getSnippet(
                'tab/title',
                'backend/viison_pickware_erp_article_supplier_assignment/main'
            ),
            tabConfig: {
                name: 'viison_pickware_erp_article_supplier_assignment-tab',
            },
            contentFn: this.createViisonPickwareERPArticleSupplierAssignmentTab,
            articleChangeFn: function (article) {
                var controller = this.subApplication.getController(
                    'Shopware.apps.ViisonPickwareERPArticleSupplierAssignment.controller.Main'
                );
                controller.setArticle(article);
            },
            scope: this,
        });

        return tabPanel;
    },

    /**
     * Creates the supplier assignment tab and its controller.
     */
    createViisonPickwareERPArticleSupplierAssignmentTab: function (article, stores, eOpts) {
        // Create main controller
        this.subApplication.addController({
            name: 'Shopware.apps.ViisonPickwareERPArticleSupplierAssignment.controller.Main',
        });
        var controller = this.subApplication.getController('Shopware.apps.ViisonPickwareERPArticleSupplierAssignment.controller.Main');
        controller.setArticle(article);

        eOpts.tab.add(controller.createAssignmentTab());
        eOpts.tab.setDisabled(article.get('id') === null);
    },

});
