// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleSupplierOrderList.view.detail.SupplierOrderList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_article_supplier_order_list-detail-supplier_order_list',
    cls: 'viison_pickware_erp_article_supplier_order_list-detail-supplier_order_list viison-common--grid has--vertical-lines has--no-borders',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_article_supplier_order_list/main',

    viewConfig: {
        enableTextSelection: true,
    },

    style: {
        borderBottom: '1px solid #a4b5c0 !important',
    },
    border: true,

    /**
     * @Override
     */
    initComponent: function () {
        this.SUPPLIER_ORDER_STATUS_CANCELED = 5;
        this.emptyText = this.getViisonSnippet('list/empty_text');
        this.columns = this.createColumns();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createColumns: function () {
        return [{
            header: this.getViisonSnippet('order/field/supplier_name'),
            dataIndex: 'supplierId',
            flex: 1,
            renderer: function (value, meta, record) {
                return (record.raw.supplier) ? record.getSupplier().get('name') : this.getViisonSnippet('order_list/column/supplier_name/unknown');
            },
        }, {
            header: this.getViisonSnippet('order/field/order_number'),
            dataIndex: 'orderNumber',
            width: 90,
        }, {
            header: this.getViisonSnippet('order/field/status'),
            dataIndex: 'statusId',
            width: 150,
            renderer: function (value) {
                var record = this.orderStatusStore.getById(value);

                return (record === null) ? '' : record.get('description');
            },
        }, {
            header: this.getViisonSnippet('order/field/target_warehouse'),
            dataIndex: 'warehouse.code',
            width: 75,
            renderer: function (value, meta, record) {
                return record.getWarehouse().get('code');
            },
        }, {
            xtype: 'datecolumn',
            header: this.getViisonSnippet('order/field/created'),
            dataIndex: 'created',
            width: 130,
            format: 'd.m.Y H:i',
        }, {
            xtype: 'datecolumn',
            header: this.getViisonSnippet('order/field/delivery_date'),
            dataIndex: 'deliveryDate',
            width: 80,
            format: 'd.m.Y',
        }, {
            sortable: false,
            header: this.getViisonSnippet('order_list/column/pending_quantity'),
            align: 'right',
            width: 120,
            renderer: function (value, meta, record) {
                if (record.items() && record.items().first()) {
                    var article = record.items().first();
                    if (article.get('statusId') === this.SUPPLIER_ORDER_STATUS_CANCELED) {
                        return 0;
                    }

                    return article.get('incomingQuantity');
                }

                return 0;
            },
        }, {
            sortable: false,
            header: this.getViisonSnippet('order_list/column/delivered_quantity'),
            align: 'right',
            width: 120,
            renderer: function (value, meta, record) {
                if (record.items() && record.items().first()) {
                    // Display the deliveredQuantity
                    var article = record.items().first();

                    return article.get('deliveredQuantity');
                }

                return 0;
            },
        }, {
            xtype: 'actioncolumn',
            hideable: false,
            align: 'center',
            width: 40,
            items: [{
                iconCls: 'sprite-sticky-notes-pin',
                tooltip: this.getViisonSnippet('order/tooltip/open_supplier_order'),

                handler: function (view, rowIndex) {
                    var record = view.getStore().getAt(rowIndex);
                    // Open the respective supplier order
                    Shopware.app.Application.addSubApplication({
                        name: 'Shopware.apps.ViisonPickwareERPSupplierOrders',
                        params: {
                            orderId: record.get('id'),
                        },
                    });
                },
            }],
        }];
    },

    /**
     * Creates a button toolbar located at the top as well as a paging toolbar located at the bottom.
     *
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        // Create and save a label/component for displaying the total incoming stock
        this.totalIncomingStockLabel = Ext.create('Ext.Component', {
            margin: '0 0 0 10',
            cls: 'is--viison-common--number-badge',
            data: {
                totalIncomingStock: this.totalIncomingStock,
            },
            tpl: '{totalIncomingStock}',
        });

        // Create a toolbar located at the top, containing a button for creating a new order
        var topToolbar = {
            xtype: 'toolbar',
            dock: 'top',
            ui: 'shopware-ui is--viison-common--toolbar',
            padding: '0 0 0 12',
            items: [
                {
                    xtype: 'label',
                    cls: 'is--viison-common--label',
                    text: ViisonCommonApp.getSnippet(
                        'field_label',
                        'backend/viison_common_variant_combo_box/main'
                    ) + ':',
                    margin: '0 10 6 0',
                }, {
                    xtype: 'viison_common_variant_combo_box-combo_box',
                    name: 'variantSelection',
                    width: 200,
                    hideLabel: true,
                }, {
                    xtype: 'label',
                    cls: 'is--viison-common--label',
                    text: this.getViisonSnippet('order_list/toolbar/target_warehouse_label') + ':',
                    margin: '0 10 6 15',
                }, {
                    xtype: 'viison_pickware_erp_supplier_common-warehouse_multiselection-combo-box',
                    width: 250,
                    store: this.targetWarehouseStore,
                    listeners: {
                        scope: this,
                        selectedWarehouseIdsChanged: function (combobox, selectedWarehouseIds) {
                            var warehouseSelectionComboBoxLabel = this.getViisonSnippet('order_list/toolbar/total_incoming_stock');
                            if (selectedWarehouseIds.length > 0) {
                                warehouseSelectionComboBoxLabel += ' ' + this.getViisonSnippet('order_list/toolbar/total_incoming_stock_selection');
                            }
                            this.down('#totalIncomingStockContainer').update(warehouseSelectionComboBoxLabel + ':');
                        },
                    },
                }, '->', {
                    xtype: 'container',
                    layout: 'hbox',
                    cls: 'has--icon-incoming',
                    padding: '13 10 13 55',
                    style: {
                        backgroundColor: 'white',
                        borderLeft: '1px solid #C3CED5 !important',
                    },
                    items: [
                        {
                            xtype: 'container',
                            itemId: 'totalIncomingStockContainer',
                            cls: 'is--viison-common--label',
                            padding: '5 0 0 0',
                            html: this.getViisonSnippet('order_list/toolbar/total_incoming_stock') + ':',
                            style: {
                                fontWeight: 'bold',
                            },
                        },
                        this.totalIncomingStockLabel,
                    ],
                },
            ],
        };

        // Create a paging toolbar located at the bottom
        var bottomToolbar = {
            xtype: 'viison_common_pagination_toolbar-toolbar',
            store: this.store,
        };

        return [
            topToolbar,
            bottomToolbar,
        ];
    },

});
