// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleSupplierOrderList.view.detail.Window', {

    override: 'Shopware.apps.Article.view.detail.Window',

    /**
     * @Override
     */
    createMainTabPanel: function () {
        var tabPanel = this.callParent(arguments);

        // Register supplier order list tab panel
        this.registerAdditionalTab({
            title: ViisonCommonApp.getSnippet(
                'tab/title',
                'backend/viison_pickware_erp_article_supplier_order_list/main'
            ),
            tabConfig: {
                name: 'viison_pickware_erp_article_supplier_order_list-tab',
            },
            contentFn: this.createViisonPickwareERPArticleSupplierOrderListTab,
            articleChangeFn: function (article) {
                var controller = this.subApplication.getController(
                    'Shopware.apps.ViisonPickwareERPArticleSupplierOrderList.controller.Main'
                );
                controller.setArticle(article);
            },
            scope: this,
        });

        return tabPanel;
    },

    /**
     * Creates the supplier assignment tab and its controller.
     */
    createViisonPickwareERPArticleSupplierOrderListTab: function (article, stores, eOpts) {
        // Create main controller
        this.subApplication.addController({
            name: 'Shopware.apps.ViisonPickwareERPArticleSupplierOrderList.controller.Main',
        });
        var controller = this.subApplication.getController(
            'Shopware.apps.ViisonPickwareERPArticleSupplierOrderList.controller.Main'
        );
        controller.setArticle(this.article);

        // Create the supplier order list tab
        this.ViisonPickwareERPArticleSupplierOrderListTab = controller.createOrderListTab();

        // Add tab content and enable it, if the loaded article already exists
        eOpts.tab.add(this.ViisonPickwareERPArticleSupplierOrderListTab);
        eOpts.tab.setDisabled(this.article.get('id') === null);
    },

});
