// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleVariantConfigurator.view.variant.configurator.Mapping', {

    override: 'Shopware.apps.Article.view.variant.configurator.Mapping',

    /**
     * @Override
     */
    initComponent: function () {
        this.callParent();

        // Overwrite height setting function
        this.on('show', function () {
            this.setHeight(390);
        }, this);
    },

    /**
     * @Override
     */
    createItems: function () {
        var result = this.callParent();

        // Add hint to the bottom of the shopware text (which is the first element)
        var hint = Ext.create('Ext.container.Container', {
            html: ViisonCommonApp.getSnippet(
                'mapping/hint',
                'backend/viison_pickware_erp_article_variant_configurator/main'
            ),
            margin: '0 0 10',
            cls: 'viison-common--info-panel',
        });
        result.splice(1, 0, hint);

        return result;
    },

});
