// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleVariantsStockColumn.view.variant.List', {

    override: 'Shopware.apps.Article.view.variant.List',

    /*
     * @Override
     */
    getColumns: function () {
        var columns = this.callParent(arguments);

        // Change header and tooltip of the 'inStock' column and disable its row editor
        Ext.each(columns, function (column) {
            // Check inStock to preserve compatibility with Shopware < 5.5
            if (column.dataIndex === 'details.inStock' || column.dataIndex === 'inStock') {
                column.header = ViisonCommonApp.getSnippet(
                    'column/in_stock/header',
                    'backend/viison_pickware_erp_article_variants_stock_column/main'
                );
                column.tooltip = ViisonCommonApp.getSnippet(
                    'column/in_stock/tooltip',
                    'backend/viison_pickware_erp_article_variants_stock_column/main'
                );
                column.editor = null;

                return false;
            }

            return undefined;
        });

        return columns;
    },

});
