// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleWarehouseFieldSet.controller.Detail', {

    override: 'Shopware.apps.Article.controller.Detail',

    /**
     * @Override
     */
    init: function () {
        this.callParent(arguments);

        // Instantiate bin location list controller
        this.getController('Shopware.apps.ViisonPickwareERPArticleWarehouseFieldSet.controller.DetailBinLocationList');
    },

    /**
     * @Override
     */
    onSaveArticle: function (win, article, options) {
        // Replace the options' callback to be able to update the stock field set
        var existingCallback = (Ext.isObject(options) && Ext.isFunction(options.callback)) ? options.callback : Ext.emptyFn;
        options.callback = function (savedArticle, success) {
            if (savedArticle && success) {
                // win is null when generating article variants
                var mainWindow = win || this.getMainWindow();

                // Update the warehouse field set
                var mainDetail = savedArticle.getMainDetail().first();
                var warehouseFieldSet = mainWindow.down('viison_pickware_erp_article_warehouse_field_set-warehouse_field_set');
                warehouseFieldSet.reloadData(mainDetail);
            }

            // Call the original callback if present
            existingCallback(savedArticle, success);
        }.bind(this);

        this.callParent([win, article, options]);
    },

    /**
     * @Override
     */
    reconfigureAssociationComponents: function () {
        this.callParent(arguments);

        // Manually reload the warehouse fieldset to configure it correctly
        var warehouseFieldSet = this.getMainWindow().down('viison_pickware_erp_article_warehouse_field_set-warehouse_field_set');
        warehouseFieldSet.reloadData(this.getMainWindow().article.getMainDetail().first());
    },

});
