// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleWarehouseFieldSet.controller.DetailBinLocationList', {

    extend: 'Shopware.apps.ViisonPickwareERPArticleBinLocationList.controller.List',

    listSelectorPrefix: 'article-detail-window',

    /**
     * @param {shopware.apps.ViisonPickwareERPArticleBinLocationList.view.List} listPanel
     * @returns {object}
     */
    getArticleDetail: function (listPanel) {
        var detailWindow = listPanel.up('article-detail-window');

        return detailWindow.article.getMainDetail().first();
    },

    /**
     * @Override
     *
     * @param {Shopware.apps.ViisonPickwareERPArticleBinLocationList.view.List} listPanel
     * @returns {number|null}
     */
    getArticleDetailId: function (listPanel) {
        return this.getArticleDetail(listPanel).get('id');
    },

    /**
     * @Override
     *
     * @param {Shopware.apps.ViisonPickwareERPArticleBinLocationList.view.List} listPanel
     * @returns {number|null}
     */
    getDefaultPurchasePrice: function (listPanel) {
        return this.getArticleDetail(listPanel).get('purchasePrice');
    },

    /**
     * @Override
     *
     * Creates a callback, which reloads the warehouse field set data, updates the stock field set as well as the
     * purchase price field using the related article detail.
     *
     * @param {Shopware.apps.ViisonPickwareERPArticleBinLocationList.view.List} listPanel
     * @returns {function}
     */
    createEditWarehouseStockCallback: function (listPanel) {
        var detailWindow = listPanel.up('article-detail-window');
        var articleDetail = this.getArticleDetail(listPanel);

        return function (purchasePrice, inStock, pickwarePhysicalStockForSale, stockMin) {
            // Update article detail
            articleDetail.set('purchasePrice', purchasePrice);
            articleDetail.set('inStock', inStock);
            articleDetail.set('pickwarePhysicalStockForSale', pickwarePhysicalStockForSale);
            articleDetail.set('viisonReservedStock', 0); // Passed value is ignored and calculated instead, we just use the setter to trigger that calculation
            articleDetail.set('stockMin', stockMin);

            // Remove the updated fields from the modified fields, since their new values
            // were already persisted in the database
            delete articleDetail.modified.purchasePrice;
            delete articleDetail.modified.inStock;
            delete articleDetail.modified.pickwarePhysicalStockForSale;
            delete articleDetail.modified.stockMin;

            listPanel.store.group();
            detailWindow.down('viison_pickware_erp_article_stock_field_set-stock_field_set').reloadData(articleDetail);
            detailWindow.down('viison_pickware_erp_article_stock_field_set-stock_field_set').minimumStockField.setValue(articleDetail.get('stockMin'));
            Ext.each(detailWindow.down('article-base-field-set').items.items[1].items.items, function (item) {
                if (item.name === 'mainDetail[purchasePrice]') {
                    item.setValue(articleDetail.get('purchasePrice'));

                    return false;
                }

                return undefined;
            });
        };
    },

});
