// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleWarehouseFieldSet.controller.VariantBinLocationList', {

    extend: 'Shopware.apps.ViisonPickwareERPArticleBinLocationList.controller.List',

    listSelectorPrefix: 'article-variant-detail-window',

    /**
     * @param {shopware.apps.ViisonPickwareERPArticleBinLocationList.view.List} listPanel
     * @returns {object}
     */
    getArticleDetail: function (listPanel) {
        var detailWindow = listPanel.up('article-variant-detail-window');

        return detailWindow.record;
    },

    /**
     * @Override
     *
     * @param {shopware.apps.ViisonPickwareERPArticleBinLocationList.view.List} listPanel
     * @returns {number|null}
     */
    getArticleDetailId: function (listPanel) {
        return this.getArticleDetail(listPanel).get('id');
    },

    /**
     * @Override
     *
     * @param {Shopware.apps.ViisonPickwareERPArticleBinLocationList.view.List} listPanel
     * @returns {number|null}
     */
    getDefaultPurchasePrice: function (listPanel) {
        return this.getArticleDetail(listPanel).get('purchasePrice');
    },

    /**
     * @Override
     *
     * Creates a callback, which reloads the warehouse field set data, updates the stock field set as well as the
     * purchase price field using the related article detail.
     *
     * @param {Shopware.apps.ViisonPickwareERPArticleBinLocationList.view.List} listPanel
     * @returns {function}
     */
    createEditWarehouseStockCallback: function (listPanel) {
        var variantWindow = listPanel.up('article-variant-detail-window');
        var articleDetail = this.getArticleDetail(listPanel);

        return function (purchasePrice, inStock, pickwarePhysicalStockForSale, stockMin) {
            // Update article detail
            articleDetail.set('purchasePrice', purchasePrice);
            articleDetail.set('inStock', inStock);
            articleDetail.set('pickwarePhysicalStockForSale', pickwarePhysicalStockForSale);
            articleDetail.set('viisonReservedStock', 0); // Passed value is ignored and calculated instead, we just use the setter to trigger that calculation
            articleDetail.set('stockMin', stockMin);

            // Remove the updated fields from the modified fields, since their new values
            // were already persisted in the database
            delete articleDetail.modified.purchasePrice;
            delete articleDetail.modified.inStock;
            delete articleDetail.modified.pickwarePhysicalStockForSale;
            delete articleDetail.modified.stockMin;

            listPanel.store.group();
            variantWindow.down('viison_pickware_erp_article_stock_field_set-stock_field_set').reloadData(articleDetail);
            variantWindow.down('numberfield[name=purchasePrice]').setValue(articleDetail.get('purchasePrice'));
            variantWindow.down('viison_pickware_erp_article_stock_field_set-stock_field_set').minimumStockField.setValue(articleDetail.get('stockMin'));

            if (articleDetail.get('standard') || articleDetail.get('kind') === 1) {
                // Update detail window if variant is main detail of article
                // Remark: The warehouse stock editor will change the article's stock and stock limits immediately,
                // but Shopware will update the model instance of the main detail only in case that the variant detail
                // window is closed by clicking the "save" button. Hence a manual updating will ensure, that the
                // displayed data is still consistent even if the user edits the stock and/or the stock limits
                // and afterwards closes the variant detail window without saving the changes (by clicking on the
                // little cross in the upper right corner of the window or by clicking the cancel button).
                var detailWindow = this.getController('Detail').getMainWindow();
                detailWindow.down('viison_pickware_erp_article_bin_location_list-list').getStore().group();
                detailWindow.down('viison_pickware_erp_article_stock_field_set-stock_field_set').reloadData(articleDetail);
            }
        }.bind(this);
    },

});
