// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleWarehouseFieldSet.view.detail.Window', {

    override: 'Shopware.apps.Article.view.detail.Window',

    /**
     * @Override
     */
    onStoresLoaded: function () {
        this.callParent(arguments);

        // Update the warehouse field set
        var warehouseFieldSet = this.down('viison_pickware_erp_article_warehouse_field_set-warehouse_field_set');
        warehouseFieldSet.reloadData(this.article.getMainDetail().first());
    },

    /**
     * @Override
     */
    createBaseTab: function () {
        var container = this.callParent(arguments);
        var pos = -1;

        // Find the description field set
        Ext.Array.each(this.detailForm.items.items, function (item, index) {
            if (item.cls === Ext.baseCSSPrefix + 'article-description-field-set') {
                pos = index;

                return false;
            }

            return undefined;
        });

        // Add the warehouse field set right before the description panel
        this.detailForm.insert(
            pos,
            Ext.create('Shopware.apps.ViisonPickwareERPArticleWarehouseFieldSet.view.WarehouseFieldSet', {})
        );

        return container;
    },

});
