// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleWarehouseFieldSet.view.variant.Detail', {

    override: 'Shopware.apps.Article.view.variant.Detail',

    /**
     * @Override
     */
    initComponent: function () {
        var onAfterRender = function () {
            if (this.record) {
                var warehouseFieldSet = this.down('viison_pickware_erp_article_warehouse_field_set-warehouse_field_set');
                warehouseFieldSet.reloadData(this.record);
            }
        };

        this.on('afterrender', onAfterRender, this);
        this.on('beforedestroy', function () {
            this.subApp.articleWindow.un('afterrender', onAfterRender, this);
        }, this);

        this.callParent(arguments);
    },

    /**
     * @Override
     */
    createFormItems: function () {
        var items = this.callParent(arguments);
        var pos = -1;

        // Find the base price field set
        Ext.Array.each(items, function (item, index) {
            if (item.cls === Ext.baseCSSPrefix + 'article-base-price-field-set') {
                pos = index;

                return false;
            }

            return undefined;
        });

        // Add the warehouse field set right before the base price panel
        Ext.Array.insert(items, pos, [
            Ext.create('Shopware.apps.ViisonPickwareERPArticleWarehouseFieldSet.view.WarehouseFieldSet', {
                articleDetail: this.record,
            }),
        ]);

        return items;
    },

});
