// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPArticleWarehouseFieldSet.view.WarehouseFieldSet', {

    extend: 'Ext.form.FieldSet',
    alias: 'widget.viison_pickware_erp_article_warehouse_field_set-warehouse_field_set',
    cls: 'viison_pickware_erp_article_warehouse_field_set-warehouse_field_set',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_article_warehouse_field_set/main',

    layout: 'fit',

    /**
     * The article detail, whose data the stock field set is editing.
     */
    articleDetail: null,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('title');
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * Updates the grid panel with the data of the given article detail.
     *
     * @param Shopware.apps.Article.model.Detail articleDetail
     */
    reloadData: function (articleDetail) {
        this.articleDetail = articleDetail;
        this.gridPanel.articleDetail = this.articleDetail;

        this.gridPanel.store.clearFilter(true);
        if (this.articleDetail.get('pickwareStockManagementDisabled')) {
            this.gridPanel.store.removeAll();
            this.gridPanel.hide();
            this.stockNotManagedLabel.show();
        } else {
            if (this.articleDetail.get('id')) {
                this.gridPanel.collapseGroupsUponRefresh = true;
                this.gridPanel.store.filter('binLocationMapping.articleDetailId', this.articleDetail.get('id'));
            } else {
                this.gridPanel.store.removeAll();
            }
            this.gridPanel.show();
            this.stockNotManagedLabel.hide();
        }
    },

    /**
     * @return Ext.Component[]
     */
    createItems: function () {
        this.gridPanel = Ext.create('Shopware.apps.ViisonPickwareERPArticleBinLocationList.view.List', {
            articleDetail: this.articleDetail,
        });

        this.stockNotManagedLabel = Ext.create('Ext.form.Label', {
            text: this.getViisonSnippet('pickware_stock_management_disabled/label/text'),
            hidden: true,
        });

        return [
            this.gridPanel,
            this.stockNotManagedLabel,
        ];
    },

});
