// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPresets.controller.EditorContext', {

    extend: 'Ext.app.Controller',

    refs: [
        { ref: 'editor', selector: 'viison_pickware_erp_barcode_label_presets_editor' },
        { ref: 'editorContext', selector: 'viison_pickware_erp_barcode_label_presets_editor_context' },
    ],

    /**
     * Shows the correct editor or overlay and inits the view.
     *
     * @param {Object} preset
     */
    setPreset: function (preset) {
        this.removeOverlays();

        if (!preset.isFunctionalityInstalled()) {
            this.displayOverlay(preset.getOverlayXtype());

            return;
        }

        this.showEditor(preset);
    },

    /**
     * Displays an overlay and hides the editor.
     *
     * @param {Object} overlay
     */
    displayOverlay: function (overlay) {
        this.getEditor().hide();

        this.getEditorContext().add({
            xtype: overlay,
            flex: 1,
        });
        this.getEditorContext().doLayout();
    },

    /**
     * Shows the editor instead of the editor.
     *
     * @param {Object} preset
     */
    showEditor: function (preset) {
        this.getController('Editor').setPreset(preset);
        this.getEditor().show();
    },

    /**
     * Removes all overlays from the render tree.
     */
    removeOverlays: function () {
        this.getAllChildItems(this.getEditorContext()).forEach(function (item) {
            if (item.xtype === 'viison_pickware_erp_barcode_label_presets_editor') {
                return;
            }

            item.destroy();
        });
    },

    /**
     * Returns all child components.
     *
     * @returns {Ext.Component}
     */
    getAllChildItems: function (component) {
        return component.items.items;
    },
});
