// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPresets.model.Template', {

    extend: 'Ext.data.Model',

    fields: [
        { name: 'identifier', type: 'text' },
        {
            name: 'name',
            type: 'string',
            convert: function (value, record) {
                var translation = null;
                if (record.get('snippetName')) {
                    translation = ViisonCommonApp.getSnippet(record.get('snippetName'), record.get('snippetNamespace'));
                }

                return translation || value || '';
            },
        },
        { name: 'snippetName', type: 'text' },
        { name: 'snippetNamespace', type: 'text' },
        { name: 'imageFile', type: 'text' },
        { name: 'isDefaultTemplate', type: 'boolean' },
    ],

    hasMany: {
        model: 'Shopware.apps.ViisonPickwareERPBarcodeLabelPresets.model.TemplateBlock',
        associationKey: 'blocks',
        name: 'getBlocks',
    },

});
