// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPresets.view.editor.FieldList', {

    extend: 'Ext.grid.GridPanel',
    alias: 'widget.viison_pickware_erp_barcode_label_presets_editor_field_list',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_barcode_label_presets/main',

    cls: 'viison-common--grid has--vertical-lines has--dark-header',
    height: '100%',
    autoScroll: true,
    border: false,
    style: {
        border: 'none',
        'border-left': '1px solid #a4b5c0 !important',
    },
    viewConfig: {
        enableTextSelection: true,
    },

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('content_tab/available_text_blocks/title');
        this.columns = this.createColumns();

        this.callParent(arguments);
    },

    /**
     * Returns the columns of the field list.
     *
     * @returns {Object[]}
     */
    createColumns: function () {
        return [
            {
                dataIndex: 'variable',
                header: this.getViisonSnippet('content_tab/available_text_blocks/variable_column_title'),
                flex: 1,
            },
            {
                dataIndex: 'description',
                header: this.getViisonSnippet('content_tab/available_text_blocks/description_column_title'),
                flex: 1,
            },
            {
                xtype: 'actioncolumn',
                width: 30,
                align: 'right',
                items: [
                    {
                        iconCls: 'viison-common--icon--copy-to-clipboard',
                        tooltip: this.getViisonSnippet('content_tab/available_text_blocks/copy_action_button_tooltip'),
                        scope: this,
                        handler: function (view, rowIndex, colIndex, item, event, record) {
                            this.fireEvent('copyFieldToClipboard', record);
                        },
                    },
                ],
            },
        ];
    },
});
