// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPresets.view.editor.LayoutTab', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_erp_barcode_label_presets_editor_layout_tab',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_barcode_label_presets/main',

    autoShow: true,
    layout: 'fit',
    border: 0,

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('layout_tab/title');
        this.items = this.createLayout();

        this.callParent(arguments);
    },

    /**
     * Returns the layout tab's content.
     * @returns {Object[]}
     */
    createLayout: function () {
        return [
            {
                xtype: 'fieldset',
                margin: 0,
                padding: 0,
                border: false,
                layout: 'fit',
                items: [
                    {
                        xtype: 'hiddenfield',
                        name: 'id',
                    },
                    {
                        xtype: 'hiddenfield',
                        name: 'type',
                    },
                    {
                        xtype: 'container',
                        layout: {
                            type: 'hbox',
                            align: 'stretch',
                        },
                        items: [
                            this.createLayoutForm(),
                            this.createLayoutPreviewSidebar(),
                        ],
                    },
                ],
            },
        ];
    },

    /**
     * Create the main layout form.
     *
     * @returns {Object[]}
     */
    createLayoutForm: function () {
        return {
            xtype: 'container',
            flex: 5,
            autoScroll: true,
            padding: 25,
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            items: [
                {
                    xtype: 'label',
                    cls: 'is--viison-common--label',
                    margin: '0 0 5 0',
                    text: this.getViisonSnippet('layout_tab/template_identifier_field') + ':',
                },
                {
                    xtype: 'combobox',
                    name: 'templateIdentifier',
                    margin: '0 0 15 0',
                    hideLabel: true,
                    queryMode: 'local',
                    displayField: 'name',
                    valueField: 'identifier',
                    store: this.subApp.getStore('Templates'),
                    allowBlank: false,
                    forceSelection: true,
                    helpText: this.getViisonSnippet('layout_tab/template_identifier_tooltip'),
                    /* eslint-disable indent */
                    tpl: new Ext.XTemplate(
                        '<tpl for=".">',
                            '<div class="viison-pickware-common--barcode-label--template-selection-item x-boundlist-item">',
                                '<div class="is--image"><img src="{imageFile}" /></div>',
                                '<div class="is--title"">{name}</div> ',
                            '</div>',
                        '</tpl>'
                    ),
                    /* eslint-enable indent */
                },
                {
                    xtype: 'label',
                    cls: 'is--viison-common--label',
                    margin: '0 0 5 0',
                    text: this.getViisonSnippet('layout_tab/paper_format_field') + ':',
                },
                {
                    xtype: 'combobox',
                    name: 'paperLayoutIdentifier',
                    margin: '0 0 30 0',
                    hideLabel: true,
                    queryMode: 'local',
                    displayField: 'description',
                    valueField: 'identifier',
                    store: this.subApp.getStore('PaperLayouts'),
                    customIdentifier: 'layoutComboBox',
                    forceSelection: true,
                    allowBlank: false,
                    helpText: this.getViisonSnippet('layout_tab/paper_format_tooltip'),
                },
                {
                    xtype: 'container',
                    margin: '0 0 20 0',
                    layout: {
                        type: 'hbox',
                        align: 'stretch',
                    },
                    items: [
                        this.createLabelSizeEditor(),
                        this.createLabelPaddingEditor(),
                    ],
                },
                {
                    xtype: 'label',
                    margin: '0 0 5 0',
                    cls: 'is--viison-common--label',
                    text: this.getViisonSnippet('layout_tab/comment_field') + ':',
                },
                {
                    xtype: 'textarea',
                    name: 'comment',
                    cls: 'is--viison-common--textarea',
                    minHeight: 100,
                    hideLabel: true,
                    allowBlank: true,
                    helpText: this.getViisonSnippet('layout_tab/comment_tooltip'),
                },
            ],
        };
    },

    /**
     * Add the label size fields.
     *
     * @returns {Object[]}
     */
    createLabelSizeEditor: function () {
        return {
            xtype: 'container',
            flex: 3,
            padding: '0 30 0 0',
            style: {
                borderRight: '1px solid #CFD8DE',
            },
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            items: [
                {
                    xtype: 'label',
                    cls: 'is--viison-common--label',
                    margin: '0 0 20 0',
                    text: this.getViisonSnippet('layout_tab/paper_field') + ':',
                },
                {
                    xtype: 'container',
                    flex: 1,
                    layout: {
                        type: 'vbox',
                        align: 'stretch',
                    },
                    items: [
                        {
                            xtype: 'container',
                            margin: '0 0 0 94',
                            layout: {
                                type: 'hbox',
                                align: 'stretch',
                            },
                            items: [
                                {
                                    xtype: 'tbfill',
                                    flex: 1,
                                },
                                {
                                    xtype: 'numberfield',
                                    cls: 'is--viison-common--numberfield',
                                    name: 'paperWidth',
                                    width: 80,
                                    minValue: 0,
                                },
                                {
                                    xtype: 'tbfill',
                                    flex: 1,
                                },
                            ],
                        },
                        {
                            xtype: 'container',
                            margin: '5 0 5 0',
                            layout: {
                                type: 'hbox',
                                align: 'middle',
                            },
                            items: [
                                {
                                    xtype: 'numberfield',
                                    cls: 'is--viison-common--numberfield',
                                    name: 'paperHeight',
                                    customIdentifier: 'paperHeight',
                                    width: 80,
                                    minValue: 0,
                                },
                                {
                                    xtype: 'container',
                                    flex: 6,
                                    height: 60,
                                    margin: '5 0 5 10',
                                    style: {
                                        border: '1px solid darkgrey',
                                    },
                                },
                            ],
                        },
                    ],
                },
            ],
        };
    },

    /**
     * Create the padding fields.
     *
     * @returns {Object[]}
     */
    createLabelPaddingEditor: function () {
        return {
            xtype: 'container',
            flex: 4,
            padding: '0 0 0 30',
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            items: [
                {
                    xtype: 'label',
                    margin: '0 0 20 0',
                    cls: 'is--viison-common--label',
                    text: this.getViisonSnippet('layout_tab/padding_field') + ':',
                },
                {
                    xtype: 'container',
                    flex: 3,
                    layout: {
                        type: 'vbox',
                        align: 'stretch',
                    },
                    items: [
                        {
                            xtype: 'container',
                            layout: {
                                type: 'hbox',
                                align: 'stretch',
                            },
                            items: [
                                {
                                    xtype: 'tbfill',
                                    flex: 1,
                                },
                                {
                                    xtype: 'numberfield',
                                    cls: 'is--viison-common--numberfield',
                                    name: 'paddingTop',
                                    width: 80,
                                    allowBlank: false,
                                    minValue: 0,
                                },
                                {
                                    xtype: 'tbfill',
                                    flex: 1,
                                },
                            ],
                        },
                        {
                            xtype: 'container',
                            margin: '5 0 5 0',
                            layout: {
                                type: 'hbox',
                                align: 'middle',
                            },
                            items: [
                                {
                                    xtype: 'numberfield',
                                    cls: 'is--viison-common--numberfield',
                                    name: 'paddingLeft',
                                    allowBlank: false,
                                    width: 80,
                                    minValue: 0,
                                },
                                {
                                    xtype: 'container',
                                    flex: 1,
                                    height: 60,
                                    margin: '5 10 5 10',
                                    style: {
                                        border: '1px solid darkgrey',
                                    },
                                    items: [
                                        {
                                            xtype: 'container',
                                            flex: 1,
                                            height: 39,
                                            margin: '10 10 0 10',
                                            style: {
                                                border: '1px dashed darkgrey',
                                            },
                                        },
                                    ],
                                },
                                {
                                    xtype: 'numberfield',
                                    cls: 'is--viison-common--numberfield',
                                    name: 'paddingRight',
                                    allowBlank: false,
                                    width: 80,
                                    minValue: 0,
                                },
                            ],
                        },
                        {
                            xtype: 'container',
                            layout: {
                                type: 'hbox',
                                align: 'stretch',
                            },
                            items: [
                                {
                                    xtype: 'tbfill',
                                    flex: 1,
                                },
                                {
                                    xtype: 'numberfield',
                                    cls: 'is--viison-common--numberfield',
                                    name: 'paddingBottom',
                                    allowBlank: false,
                                    width: 80,
                                    minValue: 0,
                                },
                                {
                                    xtype: 'tbfill',
                                    flex: 1,
                                },
                            ],
                        },
                    ],
                },
            ],
        };
    },

    /**
     * Add the sidebar with the layout image.
     *
     * @returns {Object[]}
     */
    createLayoutPreviewSidebar: function () {
        return {
            xtype: 'container',
            width: 241,
            padding: 20,
            style: {
                borderLeft: '1px solid #CFD8DE',
                backgroundColor: '#f3f5f7',
            },
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            items: [
                {
                    xtype: 'label',
                    margin: '0 0 5 0',
                    cls: 'is--viison-common--label',
                    text: this.getViisonSnippet('layout_tab/template_image/label') + ':',
                },
                {
                    xtype: 'image',
                    itemId: 'templateImage',
                    width: 200,
                    height: 150,
                },
            ],
        };
    },

    /**
     * @param {Shopware.apps.ViisonPickwareERPBarcodeLabelPresets.model.Preset} preset
     */
    setPreset: function (preset) {
        var templateSelectbox = this.getTemplateSelectbox();

        if (preset.isContentEditable()) {
            templateSelectbox.enable();
            templateSelectbox.forceSelection = true;
        } else {
            templateSelectbox.disable();
            templateSelectbox.forceSelection = false;
        }

        this.loadRecord(preset);
    },

    getTemplateSelectbox: function () {
        return this.down('combobox[name=templateIdentifier]');
    },

    getTemplateImage: function () {
        return this.down('#templateImage');
    },

});
