// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPBarcodeLabelPresets.view.List', {

    extend: 'Ext.grid.GridPanel',
    alias: 'widget.viison_pickware_erp_barcode_label_presets_list',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_barcode_label_presets/main',

    cls: 'viison_pickware_erp_barcode_label_presets_list viison-common--grid has--header-size-extra-large has--dark-header',
    autoShow: true,
    width: 280,
    height: '100%',
    style: {
        border: 'none',
        borderRight: '1px solid #a4b5c0 !important',
        boxShadow: '2px 0px 0px 0 rgba(0,0,0,0.1)',
        zIndex: '100',
    },
    bodyStyle: {
        border: 'none',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('preset_list/title');
        this.columns = this.createColumns();
        this.dockedItems = this.createDockedItems();
        this.features = [this.createGroupingFeature()];

        this.callParent(arguments);
    },

    /**
     * Create the preset list fields.
     *
     * @returns {Object[]}
     */
    createColumns: function () {
        return [
            {
                header: this.getViisonSnippet('preset_list/description_column_title'),
                dataIndex: 'translatedName',
                width: 200,
            },
            {
                xtype: 'actioncolumn',
                width: 80,
                align: 'right',
                items: [
                    {
                        iconCls: 'sprite-minus-circle-frame',
                        tooltip: this.getViisonSnippet('preset_list/delete_action_button_tooltip'),
                        scope: this,
                        handler: function (grid, rowIndex, colIndex, item, event, preset) {
                            this.fireEvent('deletePreset', preset);
                        },
                        getClass: function (value, metadata, rec) {
                            return rec.isPresetDeleteable() ? '' : 'x-hide-display';
                        },
                    },
                    {
                        iconCls: 'sprite-duplicate-grid',
                        tooltip: this.getViisonSnippet('preset_list/duplicate_action_button_tooltip'),
                        scope: this,
                        getClass: function (value, metadata, rec) {
                            return rec.isPresetDuplicatable() ? '' : 'x-hide-display';
                        },
                        handler: function (grid, rowIndex, colIndex, item, event, preset) {
                            this.fireEvent('clonePreset', preset);
                        },
                    },
                    {
                        iconCls: 'sprite-pencil',
                        tooltip: this.getViisonSnippet('preset_list/edit_action_button_tooltip'),
                        scope: this,
                        handler: function (grid, rowIndex, colIndex, item, event, preset) {
                            grid.getSelectionModel().select(preset);
                        },
                    },
                ],
            },
        ];
    },

    /**
     * Add action bar above the preset list.
     *
     * @returns {Object[]}
     */
    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'top',
                ui: 'shopware-ui',
                padding: '4 4 4 4',
                items: [
                    this.createAddPresetButton(),
                ],
            },
        ];
    },

    /**
     * Creates the add preset button definition.
     *
     * @return {Object}
     */
    createAddPresetButton: function () {
        var buttonDefinition = {
            xtype: 'button',
            text: this.getViisonSnippet('preset_list/add_button'),
            iconCls: 'sprite-plus-circle',
            align: 'right',
        };

        var userCreatablePresetTypes = this.getUserCreatablePresetTypes();
        if (userCreatablePresetTypes.length === 1) {
            buttonDefinition.handler = function () {
                this.fireEvent('createPreset', userCreatablePresetTypes[0].type);
            }.bind(this);

            return buttonDefinition;
        }

        var menuItems = [];
        userCreatablePresetTypes.forEach((function (presetType) {
            menuItems.push({
                text: presetType.description,
                iconCls: 'sprite-plus-circle',
                handler: (function () {
                    this.fireEvent('createPreset', presetType.type);
                }).bind(this),
            });
        }).bind(this));

        buttonDefinition.menu = {
            xtype: 'menu',
            shadow: false,
            cls: 'shopware-ui-main-menu',
            showSeparator: false,
            plain: true,
            ui: 'shopware-ui',
            margin: '0 0 0 2',
            items: menuItems,
        };

        return buttonDefinition;
    },

    /**
     * Returns the types of preset a user may create.
     *
     * @return {Object[]}
     */
    getUserCreatablePresetTypes: function () {
        return [{
            type: 'article',
            description: this.getViisonSnippet('preset_list/add_button/article'),
        }];
    },

    /**
     * Group presets by preset type.
     *
     * @returns {Object}
     */
    createGroupingFeature: function () {
        var groupHeaderTemplate = Ext.String.format(
            '<tpl if="name == \'article\'">[0]<tpl elseif="name == \'customer_card\'">[1]<tpl else>[2]</tpl>',
            this.getViisonSnippet('preset_list/group_names/article'),
            this.getViisonSnippet('preset_list/group_names/customer_card'),
            this.getViisonSnippet('preset_list/group_names/other')
        );

        return {
            ftype: 'grouping',
            groupHeaderTpl: groupHeaderTemplate,
        };
    },

});
